<?php
/* 
  Header Injection For MyBB
  ---
  Copyright 2013 Jimmy Peٌa, http://www.jimmyscode.com

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License, version 2, as 
  published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, visit http://www.gnu.org/licenses/gpl.html
*/

// disallow direct loading of this file
if (!defined("IN_MYBB")) {
  die("Direct loading of this file is not allowed.");
}
// hook into start function, to inject header code
$plugins->add_hook('index_start', 'injectheadercode');

// required by MyBB
// info function must have same name as plugin file
function HeaderInjectionForMyBB_info() { 
  return array( 
  "name" => "هاك اكواد منطقة الرأس", 
  "description" => "يمكنك من اضافة الاكواد  (HTML, CSS, JS ) الي منطقة الراس بالاستايل", 
  "website" => "http://www.jimmyscode.com/php/header-injection-mybb-plugin/", 
  "author" => "Jimmy Pe&ntilde;a", 
  "authorsite" => "http://www.jimmyscode.com/", 
  "version" => "1.0.0", 
  "compatibility" => "16*",
	"guid" => "f84b307cd60ae900af0febfef43f221e"
  );
}

// optional function that runs when plugin is activated
// must have same name as plugin file
function HeaderInjectionForMyBB_activate() {
  global $db;

  // ***********************************************
  // create plugin settings group
  // ***********************************************
  $himybb_group = array(
    "gid" => "NULL", 
    "name" => "himybb_group", 
    "title" => "هاك اكواد منطقة الرأس", 
    "description" => "اعدادات الهاك", 
    "disporder" => "1", 
    "isdefault" => "no"
  );
  $db->insert_query("settinggroups", $himybb_group);
  $gid = $db->insert_id();

  // ***********************************************
  // create plugin settings
  // ***********************************************
  $himybb_setting = array(
    "sid" => "NULL", 
    "name" => "himybb_plugin_enabled", 
    "title" => "تفعيل / تعطيل", 
    "description" => "يمكنك تفعيل او تعطيل الهاك من هنا", 
    "optionscode" => "yesno", 
    "value" => "1", 
    "disporder" => "1", 
    "gid" => intval($gid)
  );
  $db->insert_query("settings", $himybb_setting);
  // code to be injected
  $himybb_setting = array(
    "sid" => "NULL", 
    "name" => "himybb_inject", 
    "title" => "الكود", 
    "description" => "ضع كود الكود المراد اظهاره بمنطقة الرأس وان تركتها فارغه لن يتم اضافة شي", 
    "optionscode" => "textarea", 
    "value" => '', 
    "disporder" => "2", 
    "gid" => intval($gid)
  );
  $db->insert_query("settings", $himybb_setting);
  rebuild_settings();
} // end activate function

// optional function that runs when plugin is deactivated
// must have same name as plugin file
function HeaderInjectionForMyBB_deactivate() {
  global $db;
  // delete settings first
  $db->query("DELETE FROM " . TABLE_PREFIX . "settings WHERE name IN ('himybb_plugin_enabled')");
  $db->query("DELETE FROM " . TABLE_PREFIX . "settings WHERE name IN ('himybb_inject')");
  // delete settings group
  $db->query("DELETE FROM " . TABLE_PREFIX . "settinggroups WHERE name='himybb_group'");
  rebuild_settings();
}

// main function that runs on hook
function injectheadercode() {
  global $mybb;
  global $headerinclude;

  $isenabled = (bool)$mybb->settings['himybb_plugin_enabled'];
  $codetoinsert = $mybb->settings['himybb_inject'];
    
  if ($isenabled) { // plugin is enabled
    if (strlen($codetoinsert) > 0) { // code included, inject it
      $headerinclude .= $codetoinsert;
    } // end code check
  } // end enabled check
} // end injectheadercode function
?>